/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSBusinessService;
import filenet.ws.api.uddi.WSTModel;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BindingDetail;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.BusinessInfos;
import org.apache.juddi.datatype.response.BusinessList;
import org.apache.juddi.datatype.response.RegisteredInfo;
import org.apache.juddi.datatype.response.ServiceDetail;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.datatype.response.ServiceInfos;
import org.apache.juddi.datatype.response.ServiceList;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.datatype.response.TModelList;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.proxy.RegistryProxy;

public class WSUDDIRegistry {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSUDDIRegistry";
    public static final String exactNameMatch = "exactNameMatch";
    public static final String caseSensitiveMatch = "caseSensitiveMatch";
    public static final String sortByNameAsc = "sortByNameAsc";
    public static final String sortByNameDesc = "sortByNameDesc";
    public static final String sortByDateAsc = "sortByDateAsc";
    public static final String sortByDateDesc = "sortByDateDesc";
    public static final String orLikeKeys = "orLikeKeys";
    public static final String orAllKeys = "orAllKeys";
    public static final String combineCategoryBags = "combineCategoryBags";
    public static final String serviceSubset = "serviceSubset";
    public static final String andAllKeys = "andAllKeys";
    private static final String defaultTransportClassName = "filenet.ws.api.uddi.ApacheSOAPTransport";
    private String m_name = null;
    private RegistryProxy m_proxy = null;
    private URL m_inquiryURL = null;
    private URL m_publishURL = null;
    private int m_maxRows = 100;
    private AuthToken m_authToken = null;
    private String m_username = null;
    private boolean m_bPublishingEnabled = false;

    public void releaseReferences() {
        block2: {
            try {
                this.m_name = null;
                Object m_proxy = null;
                this.m_inquiryURL = null;
                this.m_publishURL = null;
                Object m_authToken = null;
                Object var3_4 = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block2;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSUDDIRegistry(String name, String inquiryURL, String publishURL, boolean bPublishingEnabled) throws Exception {
        this.m_bPublishingEnabled = publishURL == null ? false : bPublishingEnabled;
        this.m_name = name;
        this.getUDDIProxy();
        this.setInquiryURL(inquiryURL);
        if (publishURL != null && bPublishingEnabled) {
            this.setPublishURL(publishURL);
        }
    }

    public WSUDDIRegistry(String name, URL inquiryURL, URL publishURL, boolean bPublishingEnabled) throws Exception {
        this.m_bPublishingEnabled = publishURL == null ? false : bPublishingEnabled;
        this.m_name = name;
        this.getUDDIProxy();
        this.setInquiryURL(inquiryURL);
        if (publishURL != null && bPublishingEnabled) {
            this.setPublishURL(publishURL);
        }
    }

    public WSUDDIRegistry(String name) {
        this.m_name = name;
        this.getUDDIProxy();
    }

    public RegistryProxy getUDDIProxy() {
        if (this.m_proxy == null) {
            Properties props = new Properties();
            props.setProperty("juddi.proxy.transportClass", defaultTransportClassName);
            this.m_proxy = new RegistryProxy(props);
        }
        return this.m_proxy;
    }

    public String getName() {
        return this.m_name;
    }

    public void setInquiryURL(String inquiryURL) throws Exception {
        if (inquiryURL == null) {
            return;
        }
        this.getUDDIProxy();
        if (this.m_proxy != null) {
            try {
                this.m_inquiryURL = new URL(inquiryURL);
            }
            catch (Exception ex) {
                inquiryURL = null;
                throw ex;
            }
            this.m_proxy.setInquiryURL(new URL(inquiryURL));
        }
    }

    public void setPublishURL(String publishURL) throws Exception {
        if (publishURL == null) {
            return;
        }
        this.getUDDIProxy();
        if (this.m_proxy != null) {
            try {
                this.m_publishURL = new URL(publishURL);
            }
            catch (Exception ex) {
                this.m_publishURL = null;
                throw ex;
            }
            this.setPublishURL(this.m_publishURL);
        }
    }

    public void setInquiryURL(URL inquiryURL) {
        this.getUDDIProxy();
        if (this.m_proxy != null && inquiryURL != null) {
            this.m_proxy.setInquiryURL(inquiryURL);
        }
    }

    public void setPublishURL(URL publishURL) {
        this.getUDDIProxy();
        if (this.m_proxy != null && publishURL != null) {
            this.m_publishURL = publishURL;
            this.m_proxy.setPublishURL(publishURL);
        }
    }

    public URL getInquiryURL() {
        return this.m_inquiryURL;
    }

    public URL getPublishURL() {
        return this.m_publishURL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUserInfo(String username, String password) throws Exception {
        String origPassword;
        Properties config;
        block12: {
            block11: {
                this.getUDDIProxy();
                if (this.m_proxy == null) return;
                if (username == null) return;
                if (username.trim().length() <= 0) return;
                config = System.getProperties();
                String origUsername = config.getProperty("http.basicAuthUserName");
                origPassword = config.getProperty("http.basicAuthUserName");
                if (password == null) {
                    password = "";
                }
                this.m_username = username;
                try {
                    if (this.m_authToken != null) {
                        this.m_proxy.discardAuthToken(this.m_authToken.getAuthInfo());
                        this.m_authToken = null;
                    }
                    this.m_authToken = this.m_proxy.getAuthToken(username, password);
                    Object var8_6 = null;
                    if (origUsername == null) break block11;
                    config.setProperty("http.basicAuthUserName", origUsername);
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (origUsername != null) {
                        config.setProperty("http.basicAuthUserName", origUsername);
                    } else {
                        config.remove("http.basicAuthUserName");
                    }
                    if (origPassword != null) {
                        config.setProperty("http.basicAuthPassword", origPassword);
                        throw throwable;
                    }
                    config.remove("http.basicAuthPassword");
                    throw throwable;
                }
            }
            config.remove("http.basicAuthUserName");
        }
        if (origPassword != null) {
            config.setProperty("http.basicAuthPassword", origPassword);
            return;
        }
        config.remove("http.basicAuthPassword");
    }

    public void setMaxRows(int maxRows) {
        this.m_maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.m_maxRows;
    }

    public BusinessList findBusiness(Vector names, DiscoveryURLs discoveryURLs, IdentifierBag identifierBag, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws Exception {
        return this.m_proxy.findBusiness(names, discoveryURLs, identifierBag, categoryBag, tModelBag, findQualifiers, maxRows);
    }

    public WSBusinessEntity[] findBusinessByName(String name) throws Exception {
        return this.findBusinessByName(name, true, false);
    }

    public WSBusinessEntity[] findBusinessByName(String name, boolean bCaseSensitive, boolean bExactMatch) throws Exception {
        Vector businessInfoVector;
        BusinessInfos businessInfo;
        Vector<Name> names = new Vector<Name>();
        names.add(new Name(name));
        FindQualifiers findQualifiers = new FindQualifiers();
        Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
        if (bCaseSensitive) {
            qualifier.add(new FindQualifier(caseSensitiveMatch));
        }
        if (bExactMatch) {
            qualifier.add(new FindQualifier(exactNameMatch));
        }
        findQualifiers.setFindQualifierVector(qualifier);
        BusinessList businessList = this.m_proxy.findBusiness(names, null, null, null, null, findQualifiers, this.m_maxRows);
        if (businessList != null && (businessInfo = businessList.getBusinessInfos()) != null && (businessInfoVector = businessInfo.getBusinessInfoVector()) != null && businessInfoVector.size() > 0) {
            Object obj = null;
            Vector<WSBusinessEntity> wsBusinessInfoVector = new Vector<WSBusinessEntity>();
            for (int i = 0; i < businessInfoVector.size(); ++i) {
                obj = businessInfoVector.get(i);
                if (obj == null || !(obj instanceof BusinessInfo)) continue;
                wsBusinessInfoVector.add(new WSBusinessEntity(this, obj));
            }
            if (wsBusinessInfoVector != null && wsBusinessInfoVector.size() > 0) {
                WSBusinessEntity[] businessEntities = new WSBusinessEntity[wsBusinessInfoVector.size()];
                wsBusinessInfoVector.toArray(businessEntities);
                wsBusinessInfoVector.clear();
                return businessEntities;
            }
        }
        return null;
    }

    public WSBusinessEntity findBusinessByKey(String key) throws Exception {
        if (key != null && key.length() > 0) {
            WSBusinessEntity businessEntity = new WSBusinessEntity(this, key);
            return businessEntity;
        }
        return null;
    }

    public BusinessDetail findBusinessDetailByKey(String key) throws Exception {
        if (key != null && key.length() > 0) {
            return this.m_proxy.getBusinessDetail(key);
        }
        return null;
    }

    public BusinessDetail getBusinessDetail(BusinessInfo businessInfo) throws Exception {
        if (businessInfo != null && this.m_proxy != null) {
            return this.getBusinessDetail(businessInfo.getBusinessKey());
        }
        return null;
    }

    public BusinessDetail getBusinessDetail(String businessKey) throws Exception {
        if (businessKey != null && this.m_proxy != null) {
            return this.m_proxy.getBusinessDetail(businessKey);
        }
        return null;
    }

    public Vector findServices(BusinessInfo businessInfo) throws Exception {
        if (businessInfo != null) {
            ServiceInfos serviceInfos = businessInfo.getServiceInfos();
            return this.getServices(serviceInfos);
        }
        return null;
    }

    public Vector findServices(String businessKey) throws Exception {
        ServiceList serviceList = this.m_proxy.findService(businessKey, null, null, null, null, this.m_maxRows);
        if (serviceList != null) {
            ServiceInfos serviceInfos = serviceList.getServiceInfos();
            return this.getServices(serviceInfos);
        }
        return null;
    }

    private Vector getServices(ServiceInfos serviceInfos) throws Exception {
        Vector serviceInfoVector;
        if (serviceInfos != null && (serviceInfoVector = serviceInfos.getServiceInfoVector()) != null && serviceInfoVector.size() > 0) {
            Object obj = null;
            ServiceInfo serviceInfo = null;
            for (int i = 0; i < serviceInfoVector.size(); ++i) {
                ServiceDetail sd;
                String sk;
                obj = serviceInfoVector.get(i);
                if (obj == null || !(obj instanceof ServiceInfo) || (sk = (serviceInfo = (ServiceInfo)obj).getServiceKey()) == null || (sd = this.m_proxy.getServiceDetail(sk)) == null) continue;
                return sd.getBusinessServiceVector();
            }
        }
        return null;
    }

    public Vector findBindingTemplates(BusinessService businessService) {
        if (businessService != null) {
            BindingTemplates bindingTemplates = businessService.getBindingTemplates();
            return bindingTemplates.getBindingTemplateVector();
        }
        return null;
    }

    public Vector findBindingTemplates(String serviceKey) throws Exception {
        if (serviceKey == null) {
            return null;
        }
        BindingDetail bindingDetail = this.m_proxy.findBinding(serviceKey, null, null, null, this.m_maxRows);
        if (bindingDetail == null) {
            return null;
        }
        return bindingDetail.getBindingTemplateVector();
    }

    public WSTModel[] findTModel(String name, boolean bCaseSentitive, boolean bExactMatch) throws Exception {
        if (this.m_proxy != null && name != null) {
            TModelList tModelList;
            FindQualifiers findQualifiers = new FindQualifiers();
            if (bCaseSentitive) {
                findQualifiers.addFindQualifier(new FindQualifier(caseSensitiveMatch));
            }
            if (bExactMatch) {
                findQualifiers.addFindQualifier(new FindQualifier(exactNameMatch));
            }
            if ((tModelList = this.m_proxy.findTModel(name, null, null, findQualifiers, this.m_maxRows)) == null) {
                return null;
            }
            TModelInfos tModelInfos = tModelList.getTModelInfos();
            if (tModelInfos == null) {
                return null;
            }
            Vector tModelInfoVector = tModelInfos.getTModelInfoVector();
            if (tModelInfoVector == null || tModelInfoVector.size() == 0) {
                return null;
            }
            Object obj = null;
            Vector resultTModelVector = new Vector();
            TModelInfo tModelInfo = null;
            TModelDetail tModelDetail = null;
            String tModelKey = null;
            Vector tModelVector = null;
            Object tModel = null;
            for (int i = 0; i < tModelInfoVector.size(); ++i) {
                obj = tModelInfoVector.get(i);
                if (obj == null || !(obj instanceof TModelInfo) || (tModelKey = (tModelInfo = (TModelInfo)obj).getTModelKey()) == null || (tModelDetail = this.m_proxy.getTModelDetail(tModelKey)) == null || (tModelVector = tModelDetail.getTModelVector()) == null || tModelVector.size() <= 0) continue;
                resultTModelVector.addAll(tModelVector);
            }
            if (resultTModelVector != null && resultTModelVector.size() > 0) {
                return this.toWSTModels(resultTModelVector);
            }
        }
        return null;
    }

    public WSTModel[] getTModels(Vector tModelKeys) throws Exception {
        TModelDetail tModelDetail;
        if (this.m_proxy != null && tModelKeys != null && tModelKeys.size() > 0 && (tModelDetail = this.m_proxy.getTModelDetail(tModelKeys)) != null) {
            return this.toWSTModels(tModelDetail.getTModelVector());
        }
        return null;
    }

    public WSTModel[] getTModels(String tModelKey) throws Exception {
        if (this.m_proxy == null) {
            return null;
        }
        TModelDetail tModelDetail = this.m_proxy.getTModelDetail(tModelKey);
        if (tModelDetail != null) {
            return this.toWSTModels(tModelDetail.getTModelVector());
        }
        return null;
    }

    public boolean isPublishingEnabled() {
        return this.m_bPublishingEnabled;
    }

    public String getUsername() {
        return this.m_username;
    }

    public AuthToken getAuthToken() {
        return this.m_authToken;
    }

    public AuthInfo getAuthInfo() {
        if (this.m_authToken != null) {
            return this.m_authToken.getAuthInfo();
        }
        return null;
    }

    public boolean isAuthenticated() {
        return this.m_authToken != null;
    }

    public RegisteredInfo getRegisteredInfo(AuthInfo authInfo) throws RegistryException {
        if (this.m_proxy != null && authInfo != null) {
            RegisteredInfo registeredInfo = this.m_proxy.getRegisteredInfo(authInfo);
            return registeredInfo;
        }
        return null;
    }

    private WSTModel[] toWSTModels(Vector tModels) {
        if (tModels == null || tModels.size() == 0) {
            return null;
        }
        Vector<WSTModel> wsTModelVector = new Vector<WSTModel>();
        WSTModel[] wsTModels = null;
        Object obj = null;
        for (int i = 0; i < tModels.size(); ++i) {
            obj = tModels.get(i);
            if (obj == null || !(obj instanceof TModel)) continue;
            wsTModelVector.add(new WSTModel(this, obj));
        }
        if (wsTModelVector != null && wsTModelVector.size() > 0) {
            wsTModels = new WSTModel[wsTModelVector.size()];
            wsTModelVector.toArray(wsTModels);
            wsTModelVector.clear();
        }
        return wsTModels;
    }

    public boolean deleteBusinessEntity(WSBusinessEntity business) throws Exception {
        if (!this.isAuthenticated()) {
            return false;
        }
        boolean success = true;
        if (business != null && (success &= this.deleteServices(business))) {
            try {
                Vector<String> v = new Vector<String>();
                v.add(business.getBusinessKey());
                this.m_proxy.deleteBusiness(this.getAuthInfo(), v);
            }
            catch (Exception ex) {
                success = false;
            }
        }
        return true;
    }

    public boolean deleteServices(WSBusinessEntity business) throws Exception {
        if (business == null) {
            return true;
        }
        boolean success = true;
        Vector services = business.getBusinessServices();
        if (services != null && services.size() > 0) {
            Object obj = null;
            WSBusinessService service = null;
            for (int i = 0; i < services.size(); ++i) {
                obj = services.get(i);
                if (obj == null || !(obj instanceof WSBusinessService)) continue;
                service = obj;
                success &= this.deleteService(service);
            }
        }
        return success;
    }

    public boolean deleteService(WSBusinessService service) throws Exception {
        if (!this.isAuthenticated()) {
            return false;
        }
        if (service != null) {
            this.deleteServiceReleatedTModels(service);
            Vector<String> v = new Vector<String>();
            v.add(service.getServiceKey());
            this.m_proxy.deleteService(this.getAuthInfo(), v);
        }
        return true;
    }

    private boolean deleteServiceReleatedTModels(WSBusinessService service) throws Exception {
        if (!this.isAuthenticated()) {
            return false;
        }
        WSTModel[] tModels = service.getTModels();
        if (tModels != null && tModels.length > 0) {
            Vector<String> tModelKeys = new Vector<String>();
            for (int i = 0; i < tModels.length; ++i) {
                if (tModels[i] == null) continue;
                tModelKeys.add(tModels[i].getTModelKey());
            }
            if (tModelKeys.size() > 0) {
                this.m_proxy.deleteTModel(this.getAuthInfo(), tModelKeys);
            }
        }
        return true;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.16  $";
    }
}

